/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ToggleRecipeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int recipeLocation;
    private String id;

    public ToggleRecipeMessage() {
    }

    public ToggleRecipeMessage(@NotNull IBuildingView building, int location, String id) {
        super(building);
        this.recipeLocation = location;
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.recipeLocation = buf.readInt();
        this.id = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.recipeLocation);
        buf.func_180714_a(this.id);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        AbstractCraftingBuildingModule module = building.getModuleMatching(AbstractCraftingBuildingModule.class, m -> m.getId().equals(this.id));
        module.toggle(this.recipeLocation);
    }
}

